function out = thickness(zmax,L,rho)

% Calculates the thickness correction for cosmogenic nuclide 
% production by spallation, in a sample of thickness zmax (cm)
% and density rho (g/cm3), with effective attenuation length 
% Lambda (g/cm2). 
%
% Syntax: correction = thickness(zmax, Lambda, density);
%
% Vector arguments are OK. All arguments must be the same size.
%
% Written by Greg Balco -- UW Cosmogenic Nuclide Lab
% balcs@u.washington.edu
% First version, Feb. 2001
% checked March, 2006
% Part of the CRONUS-Earth online calculators: 
%      http://hess.ess.washington.edu/math
%
% Copyright 2001-2007, University of Washington
% All rights reserved
% Developed in part with funding from the National Science Foundation.
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License, version 2,
% as published by the Free Software Foundation (www.fsf.org).
% 
% Modified 2015 to catch zero thickness NaN problem (GB).


out_1 = (L./(rho.*zmax)).*(1 - exp(((-1.*rho.*zmax)./L)));

% Catch zero thickness, which has returned NaN
zz = find(zmax == 0);
out_1(zz) = ones(size(zz));

% make vectors horizontal

if size(out_1,1) > size(out_1,2);
	out = out_1';
else;
	out = out_1;
end;

